function [ packages, remaining_samples, counter ] = find_packages_fast_Sliding_window(  ...
    samples_IN, counter, package_samples_length, training_up)
%Double sliding window detection
%   Detailed explanation goes here


packages = [];

samples_IN_length = length(samples_IN);

if samples_IN_length < package_samples_length
    remaining_samples = samples_IN';
    return;
end

% parameters working for .wav file
%threshold_corr_factor = 10;
threshold_corr_factor = 23;
window_length = 40;
energy_in_window = 0.001;
energy_window_right = sum(samples_IN(window_length+1:2*window_length).^2);
energy_window_left = sum(samples_IN(1:window_length).^2);
decision_threshold = 3;
found_package = 0;



    ii_stop = samples_IN_length-package_samples_length-window_length;
    decision_variable = zeros(ii_stop,1);
    ii = window_length+2;
    
    while ii<ii_stop
        
        % recursively calculate energy of right window
        window_right_start =  ii;
        window_right_stop = ii+window_length;
        energy_window_right = energy_window_right + ...
            samples_IN(window_right_stop).^2 - ...
            samples_IN(window_right_start-1).^2;
        
        % recursively calculate energy of left window
        window_left_start =  ii-window_length;
        window_left_stop = ii-1;
        energy_window_left = energy_window_left + ...
            samples_IN(window_left_stop).^2 - ...
            samples_IN(window_left_start-1).^2;
        
        if energy_window_left < 0.00000000000000000001
            ii = ii+1;
            continue;
        end
            
        decision_variable(ii) = energy_window_right / energy_window_left;
        
        ii = ii+1;
    end
    
    
    max_ratio = max(decision_variable);
    max_ratio = max_ratio(1);
    max_index_ratio = find(decision_variable == max_ratio);
    max_index_ratio = max_index_ratio(1);
    
    
    
    
        if max_ratio > decision_threshold
            

            % otherwise calculate cross correlation
            t_start = 1; %max(1,max_ratio-window_length-1);
            t_end = ii_stop; %min(max_ratio+window_length-1, length(samples_IN)-length(training_up));
            % Try all time shifts between t_start and t_end
            xcor_signal_training = zeros(1,t_end-t_start+1);
            for t_tmp = t_start:t_end
                % Save result for this particular t_tmp in array
                energyInSamplesIn = samples_IN(t_tmp:t_tmp+length(training_up)-1)'*samples_IN(t_tmp:t_tmp+length(training_up)-1)*length(training_up);
                xcor_signal_training(t_tmp-t_start+1) = ...
                abs(training_up*samples_IN(t_tmp:t_tmp+length(training_up)-1));  
            end

            maximum_corr = max(xcor_signal_training);
             %maximum_corr > threshold_corr && ...
            if  maximum_corr > threshold_corr_factor * abs(mean(xcor_signal_training))     
                
                max_index = find(xcor_signal_training == maximum_corr);
            
                max_index = max_index + t_start -1;

                packages = [packages; samples_IN(max_index:...
                        max_index+package_samples_length-1)'];
                found_package = found_package + 1;

                remaining_samples = samples_IN(max_index+package_samples_length:end)';
                counter = counter + max_index+package_samples_length;
                ii = max_index+package_samples_length;
                %continue;
                return;
            end
        end

    


if found_package == 0
   remaining_samples = samples_IN(max(1,end-package_samples_length-1-2*window_length):end)';
   counter = counter + length(samples_IN) - length(remaining_samples);
    
    % When we use 8-PSK there is some problem with the remaining samples,
    % commenting the above line and adding the following line fixes the
    % problem
    
  %remaining_samples = [];
end

end

